<?php
// ======================================================= //
function generateUUID()
{
    $data = openssl_random_pseudo_bytes(16);
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80); 
    $uuid = vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    return $uuid;
}
// ======================================================= //
function createClient($url, $id, $clientData, $token) 
{
    $curl = curl_init();
    $settings = json_encode(
        [
            'clients' => 
                [
                    $clientData
                ]
        ]);
    curl_setopt_array($curl, 
    [
        CURLOPT_URL => $url . '/panel/api/inbounds/addClient',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode(
            [
                'id' => (int)$id, 
                'settings' => $settings
            ]),
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Content-Type: application/json',
            'Cookie: 3x-ui=' . $token
        ),
    ]);
    $response = curl_exec($curl);
    $response = json_decode($response, true);
    curl_close($curl);
    return $response;
}
#==================================================#
function filesGet($url) 
{
    $ch = curl_init($url);
    $options = 
    [
        CURLOPT_AUTOREFERER    => true,
        CURLOPT_HEADER         => false,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT        => 30,
    ];
    curl_setopt_array($ch, $options);
    $data = curl_exec($ch);
    if (curl_errno($ch)) 
    {
        $error_msg = curl_error($ch);
        curl_close($ch);
        return "Error: $error_msg";
    }
    curl_close($ch);
    return $data;
}
// ======================================================= //
function convertVlessConfig($base64Config) 
{
    $decoded = base64_decode($base64Config);
    if (!$decoded) return $base64Config;
    return $decoded;
}
// ======================================================= //
function createConfig($invoice_id) 
{
    global $db;
    $invoice  = mysqli_fetch_assoc($db->query("SELECT * FROM `invoices` WHERE `id` = '$invoice_id'"));
    $panel    = mysqli_fetch_assoc($db->query("SELECT * FROM `servers` WHERE `name` = '{$invoice['category']}'"));
    $login    = mysqli_fetch_assoc($db->query("SELECT * FROM `tokens` WHERE `panel` = 'ثنایی'"));
    $userName = random() . '|' . $invoice['user_id'];
    $time     = (time() + (convertDaysToTimestamp($invoice['time']))) * 1000;
    $traffick = convertGigabytesToBytes($invoice['traffick']);
    $sub      = random(15);
    $clientData = [
        'id' => generateUUID(),
        'alterId' => 0,
        'email' => $userName,
        'limitIp' => 0,
        'totalGB' => $traffick,
        'expiryTime' => $time,
        'enable' => true,
        'tgId' => '',
        'subId' => $sub
    ];
    $response = createClient($panel['url'], $panel['inboundid'], $clientData, $login['token']);
    if ($response['success'] == false) return [false, $response['msg']];
    $config = convertVlessConfig(filesGet($panel['suburl'] . '/' . $sub));
    if ($config != 'Error!') $text = "✅ کانفیگ شما با موفقیت ساخته شد\n🪪 اسم کانفیگ : {$userName}\n❤️ برای استفاده کافی است روی متن زیر کلیک کنید تا کپی شود و ان را داخل برنامه مورد نظر وارد کنید\n\n👤 در صورت بروز مشکل با پشتیبانی در ارتباط باشید\n\n🔗 <code>{$config}</code>";
    else
    {
        $text = false;
        error_log(json_encode($config));
    }
    return $text;
}
// ======================================================= //
function createConfigTest($serverName)
{
    global $db;
    $panel    = mysqli_fetch_assoc($db->query("SELECT * FROM `servers` WHERE `name` = '{$serverName}'"));
    $login    = mysqli_fetch_assoc($db->query("SELECT * FROM `tokens` WHERE `panel` = 'ثنایی'"));
    $userName = random() . '|100000000';
    $time     = (time() + (10800)) * 1000;
    $traffick = convertGigabytesToBytes(0.5);
    $sub      = random(15);
    $clientData = [
        'id' => generateUUID(),
        'alterId' => 0,
        'email' => $userName,
        'limitIp' => 0,
        'totalGB' => $traffick,
        'expiryTime' => $time,
        'enable' => true,
        'tgId' => '',
        'subId' => $sub
    ];
    $response = createClient($panel['url'], $panel['inboundid'], $clientData, $login['token']);
    if ($response['success'] == false) return [false, $response['msg']];
    $config = convertVlessConfig(filesGet($panel['suburl'] . '/' . $sub));
    if ($config != 'Error!') $text = "✅ کانفیگ شما با موفقیت ساخته شد\n\n❤️ برای استفاده کافی است روی متن زیر کلیک کنید تا کپی شود و ان را داخل برنامه مورد نظر وارد کنید\n\n👤 در صورت بروز مشکل با پشتیبانی در ارتباط باشید\n\n🔗 <code>{$config}</code>";
    else
    {
        $text = false;
        error_log(json_encode($config));
    };
    return $text;
}