<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Server Management</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            padding: 20px;
        }
        form {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        label {
            display: block;
            margin-top: 10px;
            font-weight: bold;
        }
        input[type="text"], select {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        input[type="submit"] {
            background-color: #28a745;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 15px;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <?php
    require_once __DIR__ . '/../config.php';
    if (!isset($_POST['selected_row'])) 
    {
        $result = $db->query("SELECT id, name FROM servers");
    ?>
        <form method="post">
            <label for="row">Select a row:</label>
            <select name="selected_row">
                <?php while ($row = $result->fetch_assoc()) { ?>
                    <option value="<?= $row['id']; ?>"><?= $row['name']; ?></option>
                <?php } ?>
            </select>
            <input type="submit" value="Select">
        </form>
    <?php
    } 
    else 
    {
        $selected_id = $_POST['selected_row'];
        $result = $db->query("SELECT * FROM servers WHERE id = $selected_id");
        $row = $result->fetch_assoc();
    ?>
        <form method="post" action="ServerUpdate.php">
            <input type="hidden" name="id" value="<?= $row['id']; ?>">
            <label for="name">Name:</label>
            <input type="text" name="name" value="<?= $row['name']; ?>" readonly><br>
            <label for="type">Type:</label>
            <input type="text" name="type" value="<?= $row['type']; ?>"><br>
            <label for="url">URL:</label>
            <input type="text" name="url" value="<?= $row['url']; ?>"><br>
            <label for="user">User:</label>
            <input type="text" name="user" value="<?= $row['user']; ?>"><br>
            <label for="pass">Password:</label>
            <input type="text" name="pass" value="<?= $row['pass']; ?>"><br>
            <label for="inboundid">Inbound ID:</label>
            <input type="text" name="inboundid" value="<?= $row['inboundid']; ?>"><br>
            <label for="inboundport">Sub URL:</label>
            <input type="text" name="inboundport" value="<?= $row['suburl']; ?>"><br>
            <label for="status">Status:</label>
            <select name="status">
                <option value="on" <?= $row['status'] === 'on' ? 'selected' : '' ?>>on</option>
                <option value="off" <?= $row['status'] === 'off' ? 'selected' : '' ?>>off</option>
            </select><br>
            <input type="submit" value="Update">
        </form>
    <?php
    }
    $db->close();
    ?>
</body>
</html>