<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Server Login Status</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f9;
            color: #333;
        }
        h1 {
            text-align: center;
            color: #444;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #0078d4;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .success {
            color: green;
            font-weight: bold;
        }
        .fail {
            color: red;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>Server Login Status</h1>
    <table>
        <tr>
            <th>Server Name</th>
            <th>Status</th>
        </tr>
        <?php
        require_once __DIR__ . '/../config.php';
        require_once __DIR__ . '/../text/main.php';
        function loginsanaii($address, $username, $password) 
        {
            $curlOptions = 
            [
                CURLOPT_URL            => $address . '/login',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING       => '',
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => 'POST',
                CURLOPT_POSTFIELDS     => http_build_query(['username' => $username, 'password' => $password]),
            ];
            $curl = curl_init();
            curl_setopt_array($curl, $curlOptions);
            $response = curl_exec($curl);
            if (curl_errno($curl)) return ['success' => false, 'error' => curl_error($curl)];
            $body = json_decode($response, true);
            curl_close($curl);
            return ['success' => $body['success'] ?? false, 'body' => $body['msg'] ?? 'Unknown error'];
        }
        function loginmarzban($address, $username, $password) 
        {
            $fields = [
                'username' => $username,
                'password' => $password
            ];
            $curl = curl_init($address . '/api/admin/token');
            curl_setopt_array($curl, 
            [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($fields),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/x-www-form-urlencoded',
                    'accept: application/json'
                ]
            ]);
            $response = curl_exec($curl);
            curl_close($curl);
            if ($response === false) return ['success' => false, 'error' => 'NULL response'];
            $result = json_decode($response, true);
            return isset($result['access_token']) ? ['success' => true, 'body' => 'OK'] : ['success' => false, 'error' => $result['detail'] ?? 'Unknown error'];
        }
        function loginbank($address = null, $username = null, $password = null)
        {
            return ['success' => true, 'body' => 'OK'];
        }
        $servers = $db->query("SELECT * FROM `servers`");
        foreach ($servers as $server) 
        {
            $fun = 'login' . $allTexts[$server['type']];
            $res = $fun($server['url'], $server['user'], $server['pass']);
            $statusClass = $res['success'] ? 'success' : 'fail';
            $statusText = $res['success'] ? 'Success ✅' : 'Fail ❌';
            echo "<tr>
                    <td>{$server['name']}</td>
                    <td class='{$statusClass}'>{$statusText}</td>
                  </tr>";
        }
        ?>
    </table>
</body>
</html>