<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions/main.php';
require_once __DIR__ . '/../text/main.php';
$coupon = $db->query("SELECT * FROM `copon`");
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لیست کوپن‌ها</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .coupon-container {
            max-width: 600px;
            margin: auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .coupon {
            border: 1px solid #e0e0e0;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 15px;
            background-color: #f1f1f1;
            transition: background-color 0.3s;
        }
        .coupon:hover {
            background-color: #e9ecef;
        }
        .coupon-code {
            font-weight: bold;
            font-size: 18px;
        }
        .coupon-details {
            margin-top: 5px;
            font-size: 14px;
        }
    </style>
</head>
<body>
<div class="coupon-container">
    <?php foreach ($coupon as $item): ?>
        <div class="coupon">
            <div class="coupon-code">Code: <?= htmlspecialchars($item['code']) ?></div>
            <div class="coupon-details">
                Amount: <?= htmlspecialchars($item['amount']) ?> <br>
                Usage : <?= htmlspecialchars($item['usage']) ?> <br>
                Type : <?= htmlspecialchars($allTexts[$item['type']]) ?> <br>
                Expire : <?= date('Y/m/d | H:i:s', $item['expiry_date']) ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
</body>
</html>